'use strict';

/* --------------------------------------------------------------
 search.js 2024-07-11
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2024 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

jse.libs.search = jse.libs.search || {};

/**
 * ## Admin search library.
 *
 * This module provides the search URLs and the configuration key for the admin search controller.
 * Additionally you can set a pre-defined search value by overriding the default search value.
 *
 * @module Admin/Libs/search
 * @exports jse.libs.search
 */
(function (exports) {
    // User configuration key.
    exports.configurationKey = 'recent_search_area';

    // Search areas URLs.
    exports.urls = {
        // Customers
        customers: 'customers?' + $.param({ search: '' }),

        // Categories and products
        categories: 'categories.php?' + $.param({ search: '' }),

        // Configurations
        configurations: 'configurations?' + $.param({ query: '' }),

        // Orders
        orders: 'admin.php?' + $.param({
            do: 'OrdersOverview',
            filter: {
                number: ''
            }
        }),

        // Invoices
        invoices: 'admin.php?' + $.param({
            do: 'InvoicesOverview',
            filter: {
                invoiceNumber: ''
            }
        }),

        // Manual
        manual: 'admin.php?' + $.param({
            do: 'DirectHelpProxy/GoToManual',
            search: ''
        }),

        // Forum
        forum: 'admin.php?' + $.param({
            do: 'DirectHelpProxy/GoToForum',
            number: Math.floor(Math.random() * 99999999 + 1),
            search: ''
        })
    };

    /**
     * Replaces the admin search input value with the given one.
     *
     * @param {String} term Search term.
     * @param {Boolean} doFocus Do focus on the input field?
     */
    exports.setValue = function (term, doFocus) {
        return $('#search-controller').trigger('set:value', [term, doFocus]);
    };
})(jse.libs.search);
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
